---
generated_at: 2026-01-27 12:20:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-Menubar - Help 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/js/Menubar.Help.js` - Helpメニューの実装ファイル（74行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Source CodeのリンクはGitHubのeditorディレクトリ | E-01 (26行目) | ○ |
| C-02 | AboutのリンクはThreejs.org | E-01 (52行目) | ○ |
| C-03 | ManualのリンクはGitHub Wikiのエディタマニュアル | E-01 (64行目) | ○ |
| C-04 | すべてのリンクは'_blank'ターゲットで開かれる | E-01 (26, 52, 64行目) | ○ |
| C-05 | window.open()で新しいタブを開く | E-01 (26, 52, 64行目) | ○ |
| C-06 | UIPanel/UIRowでメニュー構造を構築 | E-01 (8-17行目) | ○ |
| C-07 | strings.getKey()でメニューテキストを取得 | E-01 (12, 23, 49, 61行目) | ○ |
| C-08 | Iconsメニュー項目はコメントアウトされている | E-01 (31-43行目) | ○ |
| C-09 | Iconsのリンク先はFlaticon | E-01 (39行目) | ○ |
| C-10 | 関連機能にEventDispatcherが含まれる | E-03 (72行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張についてソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [x] 各メニュー項目のリンク先URLが正確か
- [x] リンクのターゲット属性が正確か
- [x] コメントアウトされたIconsメニューの記載が正確か
- [x] 関連機能一覧が画面機能マッピングと一致しているか
